// RunUO 2.0 Venus Dzenlemesi <admin@venus.gen.tr>

using System;
using Server;
using Server.Spells.Necromancy;

namespace Server.Items
{
	public class CureLevelInfo
	{
		private Poison m_Poison;
		private double m_Chance;
		public Poison Poison
		{
			get{ return m_Poison; }
		}
		public double Chance
		{
			get{ return m_Chance; }
		}
		public CureLevelInfo( Poison poison, double chance )
		{
			m_Poison = poison;
			m_Chance = chance;
		}
	}
	public abstract class BaseCurePotion : BasePotion
	{
		public abstract CureLevelInfo[] LevelInfo{ get; }
		public BaseCurePotion( PotionEffect effect ) : base( 0xF07, effect )
		{
		}
		public BaseCurePotion( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
		public void DoCure( Mobile from )
		{
			bool cure = false;
			CureLevelInfo[] info = LevelInfo;
			for ( int i = 0; i < info.Length; ++i )
			{
				CureLevelInfo li = info[i];
				if ( li.Poison == from.Poison && Scale( from, li.Chance ) > Utility.RandomDouble() )
				{
					cure = true;
					break;
				}
			}
			if ( cure && from.CurePoison( from ) )
			{
				from.SendLocalizedMessage( 500231 ); // You feel cured of poison!
				from.FixedEffect( 0x373A, 10, 15 );
				from.PlaySound( 0x1E0 );
			}
			else if ( !cure )
				from.SendLocalizedMessage( 500232 ); // That potion was not strong enough to cure your ailment!
		}
		public override void Drink( Mobile from )
		{
			if ( TransformationSpell.UnderTransformation( from, typeof( Spells.Necromancy.VampiricEmbraceSpell ) ) )
				from.SendLocalizedMessage( 1061652 ); // The garlic in the potion would surely kill you.
			else if ( from.Poisoned )
			{
				DoCure( from );
				BasePotion.PlayDrinkEffect( from );
				from.FixedParticles( 0x373A, 10, 15, 5012, EffectLayer.Waist );
				from.PlaySound( 0x1E0 );
				this.Delete();
			}
			else
				from.SendLocalizedMessage( 1042000 ); // You are not poisoned.
		}
	}

	public class LesserCurePotion : BaseCurePotion
	{
		private static CureLevelInfo[] m_OldLevelInfo = new CureLevelInfo[]
			{
				new CureLevelInfo( Poison.Lesser,  1.00 ), // 75% chance to cure lesser poison
				new CureLevelInfo( Poison.Regular, 0.75 ), // 50% chance to cure regular poison
				new CureLevelInfo( Poison.Greater, 0.50 )  // 15% chance to cure greater poison
			};
		private static CureLevelInfo[] m_AosLevelInfo = new CureLevelInfo[]
			{
				new CureLevelInfo( Poison.Lesser,  1.00 ),
				new CureLevelInfo( Poison.Regular, 0.80 ),
				new CureLevelInfo( Poison.Greater, 0.60 )
			};
		public override CureLevelInfo[] LevelInfo{ get{ return Core.AOS ? m_AosLevelInfo : m_OldLevelInfo; } }
		[Constructable]
		public LesserCurePotion() : base( PotionEffect.CureLesser )
		{
		}
		public LesserCurePotion( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class CurePotion : BaseCurePotion
	{
		private static CureLevelInfo[] m_OldLevelInfo = new CureLevelInfo[]
			{
				new CureLevelInfo( Poison.Lesser,  1.00 ), // 100% chance to cure lesser poison
				new CureLevelInfo( Poison.Regular, 0.80 ), //  75% chance to cure regular poison
				new CureLevelInfo( Poison.Greater, 0.60 ), //  50% chance to cure greater poison
				new CureLevelInfo( Poison.Deadly,  0.50 )  //  15% chance to cure deadly poison
			};
		private static CureLevelInfo[] m_AosLevelInfo = new CureLevelInfo[]
			{
				new CureLevelInfo( Poison.Lesser,  1.00 ),
				new CureLevelInfo( Poison.Regular, 1.00 ),
				new CureLevelInfo( Poison.Greater, 0.80 ),
				new CureLevelInfo( Poison.Deadly,  0.60 ),
				new CureLevelInfo( Poison.Lethal,  0.40 )
			};
		public override CureLevelInfo[] LevelInfo{ get{ return Core.AOS ? m_AosLevelInfo : m_OldLevelInfo; } }
		[Constructable]
		public CurePotion() : base( PotionEffect.Cure )
		{
		}
		public CurePotion( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}

	public class GreaterCurePotion : BaseCurePotion
	{
		private static CureLevelInfo[] m_OldLevelInfo = new CureLevelInfo[]
			{
				new CureLevelInfo( Poison.Lesser,  1.00 ), // 100% chance to cure lesser poison
				new CureLevelInfo( Poison.Regular, 1.00 ), // 100% chance to cure regular poison
				new CureLevelInfo( Poison.Greater, 0.80 ), // 100% chance to cure greater poison
				new CureLevelInfo( Poison.Deadly,  0.60 ), //  75% chance to cure deadly poison
				new CureLevelInfo( Poison.Lethal,  0.50 )  //  25% chance to cure lethal poison
			};

		private static CureLevelInfo[] m_AosLevelInfo = new CureLevelInfo[]
			{
				new CureLevelInfo( Poison.Lesser,  1.00 ),
				new CureLevelInfo( Poison.Regular, 1.00 ),
				new CureLevelInfo( Poison.Greater, 0.90 ),
				new CureLevelInfo( Poison.Deadly,  0.70 ),
				new CureLevelInfo( Poison.Lethal,  0.50 )
			};

		public override CureLevelInfo[] LevelInfo{ get{ return Core.AOS ? m_AosLevelInfo : m_OldLevelInfo; } }
		[Constructable]
		public GreaterCurePotion() : base( PotionEffect.CureGreater )
		{
		}

		public GreaterCurePotion( Serial serial ) : base( serial )
		{
		}
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 ); // version
		}
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}